/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.network;

import com.iafenvoy.jupiter.Jupiter;
import com.iafenvoy.jupiter.ServerConfigManager;
import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import com.iafenvoy.jupiter.network.ByteBufHelper;
import com.iafenvoy.jupiter.network.NetworkConstants;
import com.iafenvoy.jupiter.network.ServerNetworkHelper;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class ServerConfigNetwork {
    public static void init() {
        ServerNetworkHelper.INSTANCE.registerReceiver(NetworkConstants.CONFIG_REQUEST_C2S, (server, player, buf) -> ServerConfigNetwork.onConfigRequest(server, player, buf.method_10810()));
        ServerNetworkHelper.INSTANCE.registerReceiver(NetworkConstants.CONFIG_SYNC_C2S, (server, player, buf) -> ServerConfigNetwork.onConfigSync(server, player, buf.method_10810(), buf.method_10798()));
    }

    private static Runnable onConfigRequest(MinecraftServer server, class_3222 player, class_2960 id) {
        class_2487 compound;
        Jupiter.LOGGER.info("Player {} request to get config {}", (Object)player.method_5477().getString(), (Object)id);
        boolean b = ServerConfigManager.checkPermission(id, server, player, false);
        if (b) {
            AbstractConfigContainer data = ServerConfigManager.getConfig(id);
            if (data == null) {
                compound = new class_2487();
                b = false;
            } else {
                compound = data.serializeNbt();
            }
        } else {
            compound = new class_2487();
        }
        class_2540 buf = ByteBufHelper.create();
        buf.method_10812(id);
        buf.writeBoolean(b);
        buf.method_10794(compound);
        return () -> ServerNetworkHelper.INSTANCE.sendToPlayer(player, NetworkConstants.CONFIG_SYNC_S2C, buf);
    }

    private static Runnable onConfigSync(MinecraftServer server, class_3222 player, class_2960 id, class_2487 data) {
        Jupiter.LOGGER.info("Player {} request to change config {}", (Object)player.method_5477().getString(), (Object)id);
        return () -> {
            if (ServerConfigManager.checkPermission(id, server, player, true)) {
                AbstractConfigContainer container = ServerConfigManager.getConfig(id);
                if (container != null) {
                    Jupiter.LOGGER.info(data.toString());
                    container.deserializeNbt(data);
                    container.onConfigsChanged();
                    Jupiter.LOGGER.info("Player {} changed config {}", (Object)player.method_5477().getString(), (Object)id);
                }
            } else {
                ServerNetworkHelper.INSTANCE.sendToPlayer(player, NetworkConstants.CONFIG_ERROR_S2C, ByteBufHelper.create());
            }
        };
    }
}

